<?php

namespace App\Http\Controllers;

use App\Models\Questionnaire;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Illuminate\Http\RedirectResponse;

class QuestionnaireController extends Controller
{
    // Misalnya pada method `index`:
    // Controller method
    public function index()
    {
        $questionnaires = Questionnaire::all();  // Ambil semua kuisioner
        return Inertia::render('Questions', [
            'questionnaires' => $questionnaires
        ]);
    }



    public function create()
    {
        return Inertia::render('Questionnaires/Create');
    }

    public function store(Request $request): RedirectResponse
    {
        $data = $request->validate([
            'question_text' => 'required|string|max:255',
            'is_active' => 'boolean',
        ]);

        $questionnaire = Questionnaire::create($data);

        return redirect()->route('questionnaires.index')
            ->with('success', 'Kuisioner berhasil ditambahkan.')
            ->with('newQuestion', $questionnaire); // Optional kalau mau ngoper datanya

    }

    public function update(Request $request, Questionnaire $questionnaire)
    {
        $data = $request->validate([
            'question_text' => 'required|string|max:255',
            'is_active' => 'boolean'
        ]);

        $questionnaire->update($data);

        return redirect()->route('questionnaires.index')->with('success', 'Kuisioner berhasil diperbarui.');
    }

    public function destroy(Questionnaire $questionnaire)
    {
        $questionnaire->delete();
        return redirect()->route('questionnaires.index')->with('success', 'Kuisioner berhasil dihapus.');
    }
}
