<?php

namespace App\Models;

use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Anggota extends Model
{
    use HasFactory;

    // Karena nama tabel Anda adalah 'anggotas' (jamak),
    // Anda TIDAK perlu mendefinisikan protected $table di sini.
    // Laravel sudah secara default akan mencari 'anggotas'.

    protected $fillable = [
        'nama',
        'no_kta',
        'no_wa',
        'email',
        'sumber',
        'nama_perusahaan',
        'alamat',
        'uuid',
        'qr_code_path',
        'wa_sent',
        'email_sent',
        'wa_error_log',
        'email_error_log',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($anggota) {
            // Pastikan UUID di-generate jika belum ada
            if (empty($anggota->uuid)) {
                $anggota->uuid = (string) Str::uuid();
            }
        });
    }

    /**
     * Get the attendance records for the Anggota.
     * Definisi relasi hasMany ke model Kehadiran.
     */
    public function kehadirans()
    {
        return $this->hasMany(Kehadiran::class, 'anggota_id');
        // 'anggota_id' adalah foreign key di tabel 'kehadirans'
    }
}
