<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Kehadiran extends Model
{
    use HasFactory;

    // --- TAMBAHKAN BARIS INI ---
    protected $table = 'kehadiran'; // Nama tabel yang sebenarnya di database
    // -------------------------

    protected $fillable = [
        'anggota_id',
        'waktu_hadir',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'waktu_hadir' => 'datetime', // <--- Pastikan baris ini ada
    ];
    /**
     * Get the anggota that owns the Kehadiran.
     */
    public function anggota()
    {
        return $this->belongsTo(Anggota::class);
    }
}
