<?php
// app/Models/Response.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Response extends Model
{
    use HasFactory;

    protected $fillable = [
        'phone_number',
        'question_id',
        'answer',
        'created_at',
        'updated_at',
    ];

    /**
     * Relasi dengan model Questionnaire
     */
    public function question()
    {
        return $this->belongsTo(Questionnaire::class, 'question_id');
    }
}
