<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Questionnaire;

class QuestionnaireSeeder extends Seeder
{
    public function run()
    {
        $questions = [
            "Bagaimana penilaian Anda terhadap kebersihan lingkungan RS (ruang tunggu, kamar, toilet, dll)?",
            "Seberapa ramah dan membantu staf pendaftaran/resepsionis dalam melayani Anda?",
            "Bagaimana pendapat Anda tentang kecepatan pelayanan di RS ini (dari pendaftaran hingga tindakan medis)?",
            "Bagaimana penilaian Anda terhadap keramahan dan profesionalisme tenaga medis (dokter dan perawat)?",
            "Sejauh mana Anda merasa mendapatkan informasi yang jelas tentang kondisi dan pengobatan Anda dari tenaga medis?",
            "Bagaimana kualitas fasilitas dan peralatan medis yang tersedia di RS ini menurut Anda?",
            "Bagaimana kenyamanan ruang rawat inap atau ruang tunggu yang Anda gunakan?",
            "Bagaimana kemudahan akses terhadap fasilitas pendukung (parkir, kantin, apotek, dll)?",
            "Seberapa puas Anda terhadap biaya pelayanan dibandingkan dengan kualitas pelayanan yang diberikan?",
            "Secara keseluruhan, seberapa puas Anda terhadap pelayanan di RS ini? (dengan pilihan sangat tidak puas - sangat puas)"
        ];

        foreach ($questions as $questionText) {
            Questionnaire::create([
                'question_text' => $questionText,
                'is_active' => true,
            ]);
        }
    }
}
