import '../css/app.css';

import { createInertiaApp } from '@inertiajs/react';
import axios from 'axios'; // <-- Ensure this line is present and correct
import { resolvePageComponent } from 'laravel-vite-plugin/inertia-helpers';
import { createRoot } from 'react-dom/client';
import { initializeTheme } from './hooks/use-appearance';

const appName = import.meta.env.VITE_APP_NAME || 'Laravel';

// --- DEBUGGING: AXIOS REQUEST INTERCEPTOR ---
// This will log the request payload just before Axios sends it.
axios.interceptors.request.use(
    (request) => {
        console.log('--- AXIOS INTERCEPTOR: Request Payload ---', request.data);
        return request;
    },
    (error) => {
        console.error('--- AXIOS INTERCEPTOR: Request Error ---', error);
        return Promise.reject(error);
    },
);
// ------------------------------------------

createInertiaApp({
    title: (title) => `${title} - ${appName}`,
    resolve: (name) => resolvePageComponent(`./pages/${name}.tsx`, import.meta.glob('./pages/**/*.tsx')),
    setup({ el, App, props }) {
        const root = createRoot(el);
        root.render(<App {...props} />);
    },
    progress: {
        color: '#4B5563',
    },
});

// This will set light / dark mode on load...
initializeTheme();
