// resources/js/components/ui/textarea.tsx
import React from 'react';

interface TextareaProps {
  value: string;
  onChange: React.ChangeEventHandler<HTMLTextAreaElement>;
  placeholder?: string;
}

export const Textarea: React.FC<TextareaProps> = ({ value, onChange, placeholder }) => {
  return (
    <textarea
      value={value}
      onChange={onChange}
      placeholder={placeholder}
      className="border p-2 w-full"
    />
  );
};
