import AppLayout from '@/layouts/app-layout';
import { Head } from '@inertiajs/react';

export default function JawabanKuisioner({ phone_number, answers }) {
    return (
        <AppLayout>
            <Head title={`Jawaban Kuisioner - ${phone_number}`} />
            <div className="p-4">
                <h2 className="text-2xl font-semibold text-gray-800">Jawaban Kuisioner - {phone_number}</h2>
                <table className="mt-6 min-w-full table-auto border-collapse overflow-hidden rounded-lg bg-white shadow-md">
                    <thead className="bg-blue-600 text-white">
                        <tr>
                            <th className="px-6 py-3 text-left text-sm font-semibold">No</th>
                            <th className="px-6 py-3 text-left text-sm font-semibold">Pertanyaan</th>
                            <th className="px-6 py-3 text-left text-sm font-semibold">Jawaban</th>
                        </tr>
                    </thead>
                    <tbody className="divide-y divide-gray-200">
                        {answers.map((answer, index) => (
                            <tr key={index} className="transition-colors duration-200 ease-in-out hover:bg-gray-50">
                                <td className="px-6 py-4 text-sm font-medium text-gray-700">{index + 1}</td>
                                <td className="px-6 py-4 text-sm text-gray-600">{answer.question.question_text}</td>
                                <td className="px-6 py-4 text-sm text-gray-600">{answer.answer}</td>
                            </tr>
                        ))}
                    </tbody>
                </table>
            </div>
        </AppLayout>
    );
}
