import AppLayout from '@/layouts/app-layout';
import { Head, Link } from '@inertiajs/react';

export default function UsersList({ users }) {
    return (
        <AppLayout>
            <Head title="Pengunjung yang Mengisi Kuisioner" />
            <div className="p-4">
                <h2 className="text-2xl font-semibold text-gray-800">Daftar Pengunjung yang Mengisi Kuisioner</h2>
                <table className="mt-6 min-w-full table-auto border-collapse overflow-hidden rounded-lg bg-white shadow-md">
                    <thead className="bg-blue-600 text-white">
                        <tr>
                            <th className="px-6 py-3 text-left text-sm font-semibold">No</th>
                            <th className="px-6 py-3 text-left text-sm font-semibold">Nomor Telepon</th>
                            <th className="px-6 py-3 text-left text-sm font-semibold">Aksi</th> {/* Kolom aksi baru */}
                        </tr>
                    </thead>
                    <tbody className="divide-y divide-gray-200">
                        {users.map((user, index) => (
                            <tr key={index} className="transition-colors duration-200 ease-in-out hover:bg-gray-50">
                                <td className="px-6 py-4 text-sm font-medium text-gray-700">{index + 1}</td>
                                <td className="px-6 py-4 text-sm text-gray-600">{user.phone_number}</td>
                                <td className="px-6 py-4 text-sm text-gray-600">
                                    {/* Tombol Lihat Jawaban */}
                                    <Link href={`/jawaban/${user.phone_number}`} className="text-blue-600 hover:underline">
                                        Lihat Jawaban
                                    </Link>
                                </td>
                            </tr>
                        ))}
                    </tbody>
                </table>
            </div>
        </AppLayout>
    );
}
