<?php

use Illuminate\Support\Facades\Route;
use Inertia\Inertia;
use App\Http\Controllers\KuisionerController;
use App\Http\Controllers\QuestionnaireController;
use App\Http\Controllers\AnggotaController;
use App\Http\Controllers\KehadiranController;



Route::get('/', function () {
    return Inertia::render('welcome');
})->name('home');

// Dashboard route for authenticated users
Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/dashboard', [KehadiranController::class, 'showDashboard'])->name('dashboard');
});
Route::resource('questionnaires', QuestionnaireController::class);
Route::resource('data-anggota', AnggotaController::class)->parameters([
    'data-anggota' => 'anggota'
]);
Route::get('/scan', [KehadiranController::class, 'index'])->name('kehadiran.index'); // <-- Change URL from /scan-kehadiran to /scan
Route::post('/kehadiran', [KehadiranController::class, 'store'])->name('kehadiran.store');
Route::get('/kehadiran/daftar', [KehadiranController::class, 'showDaftarKehadiran'])->name('kehadiran.daftar');

// Other routes for questionnaires and users...
Route::get('/questions', [QuestionnaireController::class, 'index'])->name('questions.index');
Route::get('/users', [KuisionerController::class, 'getUsersWhoFilledQuestionnaire'])->name('users.list');
Route::get('/users', [KuisionerController::class, 'getUsersWhoFilledQuestionnaire'])->name('users.list');
Route::get('/jawaban/{phoneNumber}', [KuisionerController::class, 'viewAnswerDetails'])->name('jawaban.details');
Route::get('/kuisioner', [KuisionerController::class, 'index'])->name('kuisioner.index');
Route::post('/kuisioner', [KuisionerController::class, 'submit']);
require __DIR__ . '/settings.php';
require __DIR__ . '/auth.php';
